<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Trusthub\V1\TrustProducts;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

class TrustProductsEvaluationsContext extends InstanceContext {
    /**
     * Initialize the TrustProductsEvaluationsContext
     *
     * @param Version $version Version that contains the resource
     * @param string $trustProductSid The unique string that identifies the resource
     * @param string $sid The unique string that identifies the Evaluation resource
     */
    public function __construct(Version $version, $trustProductSid, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['trustProductSid' => $trustProductSid, 'sid' => $sid, ];

        $this->uri = '/TrustProducts/' . \rawurlencode($trustProductSid) . '/Evaluations/' . \rawurlencode($sid) . '';
    }

    /**
     * Fetch the TrustProductsEvaluationsInstance
     *
     * @return TrustProductsEvaluationsInstance Fetched
     *                                          TrustProductsEvaluationsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): TrustProductsEvaluationsInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new TrustProductsEvaluationsInstance(
            $this->version,
            $payload,
            $this->solution['trustProductSid'],
            $this->solution['sid']
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Trusthub.V1.TrustProductsEvaluationsContext ' . \implode(' ', $context) . ']';
    }
}